<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreOrderRequest;
use App\Http\Requests\UpdateOrderRequest;
use App\Http\Controllers\DocpxController;
use App\Http\Requests\MassDestroyOrderRequest;

use App\TMtotalsew;
use App\TMgenerate;
use App\TMcustomer;
use App\Tdocprexp;
use App\Torder_hd;
use App\Torder_dt;
use App\Torder_bc;
use App\TMblench;
use App\tmforuse;
use App\TMshape;
use App\TMsew;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class OrderController extends Controller
{
    private $keydoc = "10000";

    public function index()
    {
        abort_unless(\Gate::allows('order_access'), 403);
        $order = Torder_hd::getoder_hd();

        return view('admin.order.index', compact('order'));
    } //เช็คสิทธิ

    public function create()
    {
        abort_unless(\Gate::allows('order_create'), 403);
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $sizes = \DB::table('tmsize')->get();

        $orders = [
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes
        ];

        return view('admin.order.create', compact('orders'));
    }

    public function store(StoreOrderRequest $request)
    {

        abort_unless(\Gate::allows('order_create'), 403);

        // Crate Herder Order
        $Docid  = DocpxController::genid("10000");

        foreach ($request->XIOrderDNum as $Ordernum) {
            $Ordernum5[] = ceil((($Ordernum * 5) / 100));
            $Ordernum5Total[] = ceil((($Ordernum * 5) / 100)) + $Ordernum;
        }

        $OrderHD_insert = [
            'XVOrderDocNo'      => $Docid,
            'XVOrderMItemNo'    => $request->XVOrderMItemNo,
            'XIGuestCode'       => $request->XIGuestCode,
            'XIGenerateCode'    => $request->XIGenerateCode,
            'XISewCode'         => $request->XISewCode,
            'XIAddBlenchCode'   => $request->XIBlenchCode,
            'XDOrderDocMDate'   => Carbon::createFromFormat('d/m/Y', $request->XDOrderDocMDate)->format('Y-m-d'),
            'XVOrderMSeasion'   => $request->XVOrderMSeasion,
            'XIForCode'         => $request->XIForCode,
            'XIShapeCode'       => $request->XIShapeCode,
            'XITotalSewCode'    => $request->XITotalSewCode,
            'XVWhoCreate'       => Auth::user()->name,
            'XVWhoEdit'       => Auth::user()->name,
            'XCStatus'       => "1",
        ];

        $Order_hd = Torder_hd::create($OrderHD_insert);
        DocpxController::commit("10000", $Docid);

        // Crate Detail Order
        for ($i = 0; $i < count($request->XVOrderDSize); $i++) {
            $OrderDT_insert = [
                'XVOrderDocNo'      => $Docid,
                'XVOrderDSize'      => $request->XVOrderDSize[$i],
                'XIOrderDNum'       => $request->XIOrderDNum[$i],
                'XIOrderDNum5P'     => $Ordernum5[$i],
                'XIOrderDTotalNum'  => $Ordernum5Total[$i],
                'XVWhoCreate'       => $request->XVWhoCreate
            ];

            $Order_dt = Torder_dt::create($OrderDT_insert);
        }
        return redirect()->route('admin.order.index');
    }

    public function show($id)
    {

        abort_unless(\Gate::allows('order_show'), 403);
    }

    public function edit($id)
    {

        abort_unless(\Gate::allows('order_edit'), 403);

        // $Prefix       = Tdocprexp::getpx($this->keydoc)[0]->Prefix;
        $sizes = \DB::table('tmsize')->get();
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $order_hd     = Torder_hd::getoder_hd()->where('XVOrderDocNo', '=', $id)->first();
        $order_hd->XDOrderDocMDate = Carbon::createFromFormat('Y-m-d', $order_hd->XDOrderDocMDate)->format('d/m/Y');
        $order_dt     = Torder_dt::where('XVOrderDocNo', '=', $id)
            ->get();
        // dd($order_hd);

        $order = [
            'order_hd'     => $order_hd,
            'order_dt'    => $order_dt,
            'XVOrderDocNo' => $id,
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes
        ];

        return view('admin.order.edit', compact('order'));
    }


    public function update(UpdateOrderRequest $request, $Docid)
    {
        // dd('55');
        abort_unless(\Gate::allows('order_edit'), 403);


        // Crate Herder Order
        if (isset($request->XIOrderDNum)) {
            foreach ($request->XIOrderDNum as $Ordernum) {
                $Ordernum5[] = ceil((($Ordernum * 5) / 100));
                $Ordernum5Total[] = ceil((($Ordernum * 5) / 100)) + $Ordernum;
            }
        }


        // dd($request->XCStatus ,$request->XDOrderDateApprove);
        if ($request->XCStatus == "2") {
            // dd($request->XDOrderDateApprove, $status, isset($request->XIOrderDNum), Auth::user()->id);
            if ($request->XDOrderDateApprove) {
                $dateApprove = Carbon::createFromFormat('d/m/Y', $request->XDOrderDateApprove)->format('Y-m-d');
            } else {
                $dateApprove = "";
            }

            $userid = Auth::user()->id;
        } else {
            $dateApprove = null;
            $userid = null;
        }

        $OrderHD_insert = [
            'XVOrderDocNo'      => $Docid,
            'XVOrderMItemNo'    => $request->XVOrderMItemNo,
            'XIGuestCode'       => $request->XIGuestCode,
            'XIGenerateCode'    => $request->XIGenerateCode,
            'XISewCode'         => $request->XISewCode,
            'XIAddBlenchCode'   => $request->XIBlenchCode,
            'XDOrderDocMDate'   => Carbon::createFromFormat('d/m/Y', $request->XDOrderDocMDate)->format('Y-m-d'),
            'XVOrderMSeasion'   => $request->XVOrderMSeasion,
            'XIForCode'         => $request->XIForCode,
            'XIShapeCode'       => $request->XIShapeCode,
            'XITotalSewCode'    => $request->XITotalSewCode,
            'XCStatus'       => $request->XCStatus,
            'XDOrderDateApprove' => $dateApprove,
            'XIUser_id' => $userid,
            'XVWhoEdit'       => Auth::user()->name
        ];



        Torder_hd::updateorder_id($Docid, $OrderHD_insert);
        DocpxController::commit("10000", $Docid);


        // Crate Detail Order
        if (isset($request->XVOrderDSize)) {
            Torder_dt::where('XVOrderDocNo', $Docid)->delete();
            $row_dt = 1;
            for ($i = 0; $i < count($request->XVOrderDSize); $i++) {
                $OrderDT_insert = [
                    'XVOrderDocNo'      => $Docid,
                    'XVOrderDSize'      => $request->XVOrderDSize[$i],
                    'XIOrderDNum'       => $request->XIOrderDNum[$i],
                    'XIOrderDNum5P'     => $Ordernum5[$i],
                    'XIOrderDTotalNum'  => $Ordernum5Total[$i],
                    'XVWhoCreate'       => Auth::user()->name,
                    'XTWhenCreate'       => date("Y-m-d H:i:s")
                ];

                Torder_dt::where('XVOrderDocNo', $Docid)->where('XVOrderDSize', $request->XVOrderDSize[$i])->delete();
                Torder_dt::create($OrderDT_insert);
            }
        }

        ### บันทึกลงตาราง barcode

        if ($request->XCStatus == "2") {

            $bDoesntExist = \DB::table('torder_bc')->where('XVOrderDocNo', $Docid)->doesntExist();


            if ($bDoesntExist) {
                $res_sizes = \DB::table('torder_dt')->where('XVOrderDocNo', $Docid)->get()->toArray();
                $row_bc = 0;





                foreach ($res_sizes as $size) {

                    for ($num_bar = 1; $num_bar <= $size->XIOrderDTotalNum; $num_bar++) {
                        $XVOrderBCode = substr('00' . $size->XVOrderDSize, -2) . $Docid . substr("0000" . $num_bar, -4);
                        // dd($XVOrderBCode);

                        $OrderฺBC_insert[$row_bc] =  [
                            'XVOrderBCode' => $XVOrderBCode,
                            'XVOrderDocNo' => $Docid,
                            'XVOrderBSize' => $size->XVOrderDSize,
                            'XVOrderBarNo' => substr("0000" . $num_bar, -4),
                            'XVOrderBLocation' => "1",
                            'XVWhoCreate' => Auth::user()->name,
                            'XTWhenCreate' => date("Y-m-d H:i:s"),
                            'XVWhoEdit' => Auth::user()->name,
                            'XTWhenEdit' => date("Y-m-d H:i:s")
                        ];
                        $row_bc++;
                    }
                    // dd($OrderฺBC_insert);
                }
                //   dd($OrderฺBC_insert);
                if (!empty($OrderฺBC_insert)) {
                    \DB::table('torder_bc')->insert($OrderฺBC_insert);
                }
            }
        }




        return redirect()->route('admin.order.index');
    }

    public function destroy($id)
    {
        // dd(231);
        abort_unless(\Gate::allows('order_delete'), 403);

        Torder_hd::deleteorder_id($id);

        return back();
    }

    public function massDestroy(MassDestroyOrderRequest $request)
    {


        abort_unless(\Gate::allows('order_delete'), 403);



        Torder_hd::whereIn('XVOrderDocNo', request('ids'))->delete();

        return response(null, 204);
    }

    public function getApprove($DocNo)
    {
        abort_unless(\Gate::allows('order_approve'), 403);

        // $Prefix       = Tdocprexp::getpx($this->keydoc)[0]->Prefix;
        $sizes = \DB::table('tmsize')->get();
        
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $order_hd     = Torder_hd::getoder_hd()->where('XVOrderDocNo', '=', $DocNo)->first();
        $order_hd->XDOrderDocMDate = Carbon::createFromFormat('Y-m-d', $order_hd->XDOrderDocMDate)->format('d/m/Y');
        $order_dt     = Torder_dt::where('XVOrderDocNo', '=', $DocNo)->get();


        $order = [
            'order_hd'     => $order_hd,
            'order_dt'    => $order_dt,
            'XVOrderDocNo' => $DocNo,
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes
        ];

        $accessories = \DB::table('taccessories')->get();

        $accno = XVAccesCode::all();

        $accessories = [
            'XVAccesCode' => $accno
        ];

        return view('admin.order.approve', compact('order'));
    }
}
